program threadinst.dpr;
{$APPTYPE CONSOLE}

//
// This example demonstrates how to use native .NET methods to create a thread on 
// a class with an instance method.
//
// Written by: Rick Ross (http://www.rick-ross.com/)
//

uses
   System.Threading;

type
  ThreadMe = class
  private
    FStartNum : integer;
  public
    procedure MyThreadMethod;
    property StartNum : integer write FStartNum;
  end;

procedure ThreadMe.MyThreadMethod;
var
  stop : integer;
  curNum : integer;

begin
  curNum := FStartNum;
  stop := FStartNum + 10;
  while curNum < stop do
  begin
    writeln('Thread ', System.Threading.Thread.CurrentThread.Name ,
            ' current value is ',curNum);
    inc(curNum);
    Thread.Sleep( 3 );
  end; 
end;

var
  thrdclass1 : ThreadMe;
  thrdclass2 : ThreadMe;
  thrd1 : Thread;
  thrd2 : Thread;

begin
  writeln('Staring threading instance example...');

  // create myDotNetThread instance
  thrdclass1 := ThreadMe.create;
  thrdclass1.StartNum := 10;

  thrd1 := Thread.Create( @thrdclass1.MyThreadMethod );
  thrd1.Name := 'one';

  thrdclass2 := ThreadMe.create;
  thrdclass2.StartNum := 100;

  thrd2 := Thread.create( @thrdclass2.MyThreadMethod );
  thrd2.Name := 'two';

  thrd1.Start();
  thrd2.Start();

  readln;

  writeln('Done');
end.

